#include <iostream>
#include <vector>
#include <deque>
#include <list>
#include <fstream>
#include "Functions.h"

int main() {
	const std::string filePath = "..I_O-streams-and-stl/Part 1/file.txt"; //!!! Файл находится? После .. "/" не нужен? 
	const std::string resFilePath = "..I_O-streams-and-stl/Part 1/resFile.txt";  //!!! Файл находится? После .. "/" не нужен?
    
    std::vector<double> vec1;
    std::list<double> list1;
    std::deque<double> deque1;
    
	try{
        int a = -1;
        int f = -1;
        int l = -1;
        while(a != 0){
            std::cout << "1. Create data in file" << std::endl;
            std::cout << "2. Load data to containers" << std::endl;
            std::cout << "3. Modify data" << std::endl;
            std::cout << "4. Output data from the file" << std::endl;
            std::cout << "5. Output containers" << std::endl;
            std::cout << "0. Exit" << std::endl;
            std::cin >> a;
        
            switch (a) {
                case 1:
                    std::cout << std::endl << "1. Create data with random" << std::endl;
                    std::cout << "2. Create data with container" << std::endl;
                    std::cin >> f;
                    switch (f) {
                        case 1:
                            createData_1(filePath);
                            std::cout << "Success!" << std::endl << std::endl;
                            break;
                        case 2:
                            createData_2(filePath);
                            std::cout << "Success!" << std::endl << std::endl;
                            break;
                        default:
                            while((a < 0) || (a > 2)){
                                std::cout << "Wrong number! Try again" << std::endl;
                                std::cin >> a;
                            }
                            break;
                    }
                    break;
                    
                case 2:
                    std::cout << std::endl << "1. Load with fstream" << std::endl;
                    std::cout << "2. Load with stream iter" << std::endl;
                    std::cin >> f;
                    switch (f) {
                        case 1:
                            vec1 = loadData_1<std::vector<double>>(filePath);
                            list1 = loadData_1<std::list<double>>(filePath);
                            deque1 = loadData_1<std::deque<double>>(filePath);
                            std::cout << "Success!" << std::endl << std::endl;
                            break;
                        case 2:
                            vec1 = loadData_2<std::vector<double>>(filePath);
                            list1 = loadData_2<std::list<double>>(filePath);
                            deque1 = loadData_2<std::deque<double>>(filePath);
                            std::cout << "Success!" << std::endl << std::endl;
                            break;
                        default:
                            while((a < 0) || (a > 2)){
                                std::cout << "Wrong number! Try again" << std::endl;
                                std::cin >> a;
                            }
                            break;
                    }
                    break;
                    
                case 3:
                    std::cout << std::endl << "1. Modify " << std::endl;
                    std::cout << "2. Modify iter" << std::endl;
                    std::cout << "3. Modify for_each" << std::endl;
                    std::cout << "4. Modify transform" << std::endl;
                    std::cin >> f;
                    switch (f) {
                        case 1:
                            Modify(vec1);
                            Modify(list1);
                            Modify(deque1);
                            std::cout << "Success!" << std::endl << std::endl;
                            break;
                        case 2:
                            Modify(vec1.begin(), vec1.end());
                            Modify(list1.begin(), list1.end());
                            Modify(deque1.begin(), deque1.end());
                            std::cout << "Success!" << std::endl << std::endl;
                            break;
                        case 3:
                            Modify(vec1, [](auto& el){return el += 1.5;});
                            Modify(list1, [](auto& el){return el += 1.5;});
                            Modify(deque1, [](auto& el){return el += 1.5;});
                            std::cout << "Success!" << std::endl << std::endl;
                            break;
                        case 4:
                            Modify_Transform(vec1);
                            Modify_Transform(list1);
                            Modify_Transform(deque1);
                            std::cout << "Success!" << std::endl << std::endl;
                            break;
                        default:
                            while((a < 0) || (a > 4)){
                                std::cout << "Wrong number! Try again" << std::endl;
                                std::cin >> a;
                            }
                            break;
                    }
                    break;
                    
                case 4:
                    std::cout << std::endl << "1. Output with fstream" << std::endl;
                    std::cout << "2. Output with stream iter" << std::endl;
                    std::cin >> f;
                    switch (f) {
                        case 1:
                            std::cout << std::endl << "1. Vector" << std::endl;
                            std::cout << "2. List" << std::endl;
                            std::cout << "3. Deque" << std::endl;
                            std::cin >> l;
                            switch (l) {
                                case 1:
                                    outputResult_1(vec1, resFilePath);
                                    std::cout << "Success!" << std::endl << std::endl;
                                    break;
                                case 2:
                                    outputResult_1(list1, resFilePath);
                                    std::cout << "Success!" << std::endl << std::endl;
                                    break;
                                case 3:
                                    outputResult_1(deque1, resFilePath);
                                    std::cout << "Success!" << std::endl << std::endl;
                                    break;
                                default:
                                    break;
                            }
                            break;
                        case 2:
                            std::cout << std::endl << "1. Vector" << std::endl;
                            std::cout << "2. List" << std::endl;
                            std::cout << "3. Deque" << std::endl;
                            std::cin >> l;
                            switch (l) {
                                case 1:
                                    outputResult_2(vec1, resFilePath);
                                    std::cout << "Success!" << std::endl << std::endl;
                                    break;
                                case 2:
                                    outputResult_2(list1, resFilePath);
                                    std::cout << "Success!" << std::endl << std::endl;
                                    break;
                                case 3:
                                    outputResult_2(deque1, resFilePath);
                                    std::cout << "Success!" << std::endl << std::endl;
                                    break;
                                default:
                                    break;
                            }
                            break;
                        default:
                            while((a < 0) || (a > 2)){
                                std::cout << "Wrong number! Try again" << std::endl;
                                std::cin >> a;
                            }
                            break;
                    }
                    break;
                    
                case 5:
                    std::cout << std::endl << "VECTOR" << std::endl;
                    for (auto iter : vec1) std::cout << iter << " ";
                    std::cout << std::endl << "LIST" << std::endl;
                    for (auto iter : list1) std::cout << iter << " ";
                    std::cout << std::endl << "DEQUE" << std::endl;
                    for (auto iter : deque1) std::cout << iter << " ";
                    break;
                    
                case 0:
                    break;
                default:
                    while((a < 0) || (a > 4)){
                        std::cout << "Wrong number! Try again" << std::endl;
                        std::cin >> a;
                    }
                    break;
            }
        }
	}
	catch (const std::exception& err){
		std::cout << err.what();
	}
    return 0;
}
